<?php
/**
 * Widget_Service class.
 * 
 * @since 1.0
 */

class Buildplus_Widget_Service extends WP_Widget {

	public function __construct() {
		$widget_ops = array( 'classname' => 'widget_buildplus_service', 'description' => esc_html__( "A list of services", 'buildplus' ) );
		parent::__construct( 'buildplus_services', esc_html_x( 'SLZ: Services', 'Services widget', 'buildplus' ), $widget_ops );
	}

	function form( $instance ) {
		$default = array( 
			'title'       => esc_html__( "Services", 'buildplus' ),
			'limit_post'  => '5',
			'offset_post' => '',
			'sort_by'     => '',
			'category'    => ''
		);
		$sort_arr       = Buildplus_Core_Params::get('sort-custom');
		$cat_arr        = Buildplus_Core_Com::get_tax_options2slug( 'buildplus_service_cat', array('empty'       => esc_html__( '--All Categories--', 'buildplus' ) ) );
		$instance       = wp_parse_args( (array) $instance, $default );
		$title          = $instance['title'];
		$limit_post     = $instance['limit_post'];
		$offset_post    = $instance['offset_post'];
		$sort_by        = $instance['sort_by'];
		$category       = $instance['category'];
		?>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('title') ); ?>"><?php esc_html_e( 'Title', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('limit_post') ); ?>"><?php esc_html_e( 'Number Post', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('limit_post') ); ?>" name="<?php echo esc_attr( $this->get_field_name('limit_post') ); ?>" value="<?php echo esc_attr( $limit_post ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('offset_post') ); ?>"><?php esc_html_e( 'Offset post', 'buildplus' );?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('offset_post') ); ?>" name="<?php echo esc_attr( $this->get_field_name('offset_post') ); ?>" value="<?php echo esc_attr( $offset_post ); ?>" />
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('sort_by') ); ?>"><?php esc_html_e( 'Sort By', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('sort_by') ); ?>" name="<?php echo esc_attr( $this->get_field_name('sort_by') ); ?>" >
				<?php foreach( $sort_arr  as $k => $v ){?>
					<option value="<?php echo esc_attr($v); ?>"<?php if( $sort_by == $v ) echo " selected"; ?>><?php echo esc_html($k); ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo  esc_attr( $this->get_field_id('category') ); ?>"><?php esc_html_e( 'Service Categories', 'buildplus' );?></label>
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('category') ); ?>" name="<?php echo esc_attr( $this->get_field_name('category') ); ?>" >
				<?php foreach( $cat_arr  as $k => $v ){?>
					<option value="<?php echo esc_attr($v); ?>"<?php if( $category == $v ) echo " selected"; ?>><?php echo esc_html($k); ?></option>
				<?php } ?>
			</select>
		</p>
		<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$params = array(
			'title',
			'limit_post',
			'offset_post',
			'sort_by',
			'category',
		);
		foreach( $params as $item ) {
			$instance[$item] = strip_tags( $new_instance[$item] );
		}
		return $instance;
	}

	function widget( $args, $instance ) {
		extract( $args );
		$default  = array(
			'title'           => '',
			'limit_post'      => '',
			'offset_post'     => '',
			'sort_by'         => '',
			'category'        => ''
		);
		$instance = wp_parse_args( (array) $instance, $default ); 
		extract( $instance );
		$atts = $instance;
		$model = new Buildplus_Core_Service();
		$model->init( $atts );
		$html_format = '<a href="%2$s" class="link"><span>%1$s</span><i class="icons fa fa-angle-right"></i></a>';
		$html_options = array('html_format' => $html_format);
		echo wp_kses_post( $before_widget );?>
			<div class="widget categories-widget">
			<?php
				if( !empty( $title ) ) {
					echo wp_kses_post( $before_title );
					echo esc_html( $title );
					echo wp_kses_post( $after_title );
				}
			?>
				<div class="categories-inner">
					<?php $model->render_widget($html_options);?>
				</div>
			</div><?php 
		echo wp_kses_post( $after_widget );
	}
}