<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class UserApi extends Controller
{
    public function login(Request $request)
    {
        dd($request->all());
        
        $validator = Validator::make($request->all(), [
            'email' => ['required', 'string', 'email', 'max:255'],
            'password' => ['required'],
        ]);

        if ($validator->fails()) {
            return response()->json(['status_code' => 400, 'message' => 'Bad Request']);
        }
        $credentials = request(['email', 'password']);
        $user = User::where('email', $credentials['email'])->first();
        if ($user == '') {
            return response()->json(['status_code' => 500, 'message' => 'The email or password are incorrect!']);
        } else if (!Hash::check($credentials['password'], $user->password)) {
            return response()->json(['status_code' => 500, 'message' => 'The email or password are incorrect!']);
        }
        $user = User::where('email', $credentials['email'])->first();
        
        if(strtotime($user->valid_upto)>strtotime('now')){
                return response()->json(['status_code' => 200, 'message' => 'Login successfully', 'user' => $user]);
        }else{
                 return response()->json(['status_code' => 200, 'message' => "Access Expired"]);
  
        }
        

        //$token = $user->createToken('authToken')->plainTextToken;
     }

    public function getProfile(Request $request)
    {
        $profile = User::select('users.*', 'b.branchName as branchName')->join('branches as b', 'users.branchId', 'b.id')->find($request->get('userId'));
        //dd($profile);
        $data = array([
            'STAUTS_CODE' => 200,
            'STAUTS_MESSAGE' => 'user profile get successfully',
            'OFFICER_NAME' => $profile->name,
            'OFFICER_CODE' => $profile->code,
            'PROFILE_PHOTO' => public_path() . '/storage/uploads/profile/' . $profile->profile_photo_path,
            'BRANCH_NAME' => $profile->branch->branchName,
        ]);
        return json_encode($data, JSON_UNESCAPED_SLASHES);
    }

    public function updateProfilePic(Request $request)
    {
        if ($request->file('profile_photo_path')) {
            $imagePath = $request->file('profile_photo_path');
            $imageName = time() . $imagePath->getClientOriginalName();
            $path = $request->file('profile_photo_path')->storeAs('uploads', $imageName, 'public');
            $user = User::find($request->get('userId'));
            $user->profile_photo_path = $imageName;
            $user->save();
            return response()->json(['en' => ['status_code' => 200, 'message' => 'Profile Pic Updated successfully'], 'ar' => ['status_code' => 200, 'message' => 'Profile Pic Updated successfully']]);
  
        }
        
    }

    public function logout(Request $request)
    {
        $request->user()->currentAccessToken()->delete();
        return response()->json(['status_code' => 200, 'message' => 'Token Deleted successfully']);
    }

    public function fetchUser()
    {
    }
    public function fetchBranch()
    {
    }
}
