@extends('layouts.admin')

@section('content')
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Add a User') }}
        </h2>
    </x-slot>
    <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
        @if ($errors->any())
            <div class="alert alert-danger">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div><br />
        @endif


        <div class="row">
            <div class="card shadow col-md-5 offset-sm-2 p-3">

                <form method="post" action="{{ route('users-store') }}" enctype="multipart/form-data">
                    @csrf
                    {{-- <div class=" form-group">
                        <div class="row">
                            <div class="col-md-6 form-group">
                                <label for="image"> Profile Photo:</label>
                                <input type="file" name="profile_photo_path" class="file" accept="image/*">
                                <div class="input-group my-3">
                                    <input type="text" class="form-control" disabled placeholder="Upload File"
                                        id="file">
                                    <div class="input-group-append">
                                        <button type="button" class="browse btn btn-primary">Browse</button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6 form-group">
                                <img src="https://placehold.it/80x80" id="preview" class="img-thumbnail">
                            </div>

                        </div>
                    </div> --}}
                    
                    <div class="form-group">
                        <label for="name"> Business Name:</label>
                        <input type="text" class="form-control" name="business_name" required />
                    </div>
                    <div class="form-group">
                        <label for="name"> Username:</label>
                        <input type="text" class="form-control" name="name" required />
                    </div>
                    <div class="form-group">
                        <label for="email"> Email:</label>
                        <input type="email" class="form-control" name="email" required />
                    </div>
                    <div class="form-group">
                        <label for="password"> Password:</label>
                        <input type="password" class="form-control" name="password" required />
                    </div>

                    <button class="btn btn-info" type="submit">{{ __('Add User') }}</button>
                        
                   
                </form>
            </div>
        </div>
    </div>
    <div class="max-w-7xl mx-auto py-10 sm:px-6 lg:px-8">
@endsection
